#ifndef ZMODELER_D3DDEFS_INCLUDED
#define ZMODELER_D3DDEFS_INCLUDED

///////////////////////////////////////////////////////////////////////////
//        3DEngine  constants  Definitions
///////////////////////////////////////////////////////////////////////////
#define    MAX_MATERIALNAMELEN  64

///////rendering flags
#define    ZBuffer            0x00000001
#define    BackBuffer         0x00000002
#define    TextureFiltering   0x00000004
#define    Dithering          0x00000008

#define    Specular           0x00000010
#define    ForceSoftware      0x00000020
#define    UseLighting        0x00000040

///////shading modes
#define    ShadeFlat          0x00000200 //Solid1
#define    ShadePhong         0x00000400 //Solid2

//rendering flags
#define    AlphaBlend         0x00010000
#define    AlphaTest          0x00020000
#define    ColorKeying        0x00040000
#define    UseFog             0x00080000
#define    UseTextures        0x00100000
#define    TexturesBlend      0x00200000
#define    AlwaysHighBlend    0x00400000
#define    IgnoreCustomFlags  0x00800000



//redndering BLOCK flags
#define    CullCW            0x00000001 //backward cull
#define    CullNone          0x00000002 //No cull
#define    SemiTransparent    0x00000010 //alpha on, 50% transparent;
#define    NoBlend            0x00000020 //No Blending/Chroming
#define    HighBlend          0x00000040
#define    NoTransparency    0x00000080 //disables all kinds of transparency;

#define    Bit32              0x80000000
#define    Bit31              0x40000000
#define    Bit30              0x20000000
#define    Bit29              0x10000000
#define    Bit28              0x08000000
#define    Bit27              0x04000000
#define    Bit26              0x02000000
#define    Bit25              0x01000000


///////Lighting
#define    LeftSpot          0
#define    RightSpot          1
#define    TopSpot            2
#define    BottomSpot        3
#define    ForceRGBAlphaBits  0xFF000000

///////colors:
#define    BitEnabled        Bit32
///////Wireframe
#define    BitWireShaded      Bit31
#define    BitWireTextured    Bit30
#define    BitWireOneColor    Bit29

///////Background
#define    UseBackImage      BitEnabled
#define    RotateableImage    Bit31
#define    EnvironmentMap    Bit30
#define    UserControl        Bit29
#define    DontTachIt        Bit28


//----------------------------------------------------------
//  Drawing tools definitions:
//----------------------------------------------------------
#define    DRAW_TEXTUREWALPHA  0x00000001 //rgba
#define    DRAW_TEXTURESALPHA  0x00000002 //a
#define    DRAW_TEXTURESCOLOR  0x00000004 //rgb


//----------------------------------------------------------
//  Wire Drawing: highlightion definitions:
//----------------------------------------------------------
#define    UseInViews      Bit32
#define    UseIn3DView      Bit31
#define    AdditiveHighLight  Bit30  // Src:Dest = INVSRCALPHA:DESTCOLOR
#define    ExtraHighLight    Bit29  // Src:Dest = ONE:INVDESTCOLOR
#define    CustomColor      Bit28  //&0xFFFFFF to get color;


//----------------------------------------------------------
//  FindMaterial nMatchFlags can be a combination of the following:
//----------------------------------------------------------
#define    FIND_MATCH_MATERIALNAME    0x00000001
#define    FIND_MATCH_RGB        0x00000002
#define    FIND_MATCH_RGBA        0x00000004
#define    FIND_MATCH_ALPHATREAT    0x00000008
#define    FIND_MATCH_PRIMTEXTURENAME  0x00000010
#define    FIND_MATCH_BUMPTEXTURENAME  0x00000020
#define    FIND_MATCH_REFLTEXTURENAME  0x00000040
#define    FIND_MATCH_RSRVTEXTURENAME  0x00000080
#define    FIND_MATCH_PRIMAPPLY    0x00000100
#define    FIND_MATCH_BUMPAPPLY    0x00000200
#define    FIND_MATCH_REFLAPPLY    0x00000400
#define    FIND_MATCH_RSRVAPPLY    0x00000800

extern const DWORD    MaxRenderPortion;

#endif /*ZMODELER_D3DDEFS_INCLUDED*/
